/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.vo.MosPVo;

import jp.mosp.system.dto.MCodeDto;

public class KintaiSystemDefinitionCardVo extends MosPVo {

	private static final long serialVersionUID = 3394177285993796216L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/kintaiSystemDefinitionCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/kintaiSystemDefinitionCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/kintaiSystemDefinitionCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_WORK_SYSTEM_DEFINE;

	// 萔
	public static final int MODE_UPDATE = 1;

	// p[^
	public static final String PRM_TXT_STATUTORY_HOUR			= "txtStatutoryHours";
	public static final String PRM_TXT_STATUTORY_WEEK			= "txtStatutoryWeek";
	public static final String PRM_TXT_STATUTORY_MONTH_HOURS 	= "txtStatutoryMonthHours";
	public static final String PRM_TXT_STATUTORY_MONTH_DAYS 	= "txtStatutoryMonthDays";
	public static final String PRM_PLT_CALCULATION_MONTH 		= "pltCalcMonth";
	public static final String PRM_TXT_CALCULATION_DAYS 		= "txtCalcDays";
	public static final String PRM_PLT_PROVIDED_MONTH 		= "pltProvidedMonth";
	public static final String PRM_TXT_PROVIDED_DAYS 			= "txtProvidedDays";
	public static final String PRM_TXT_INPUT_UNIT_TIMES 		= "txtInputUnit";
	public static final String PRM_PLT_AUTOMATIC_CALCULATION 	= "pltAutoCalc";
	public static final String PRM_TXT_ALL_HOLIDAY_HOUR 		= "txtAllHolidayHour";
	public static final String PRM_TXT_ALL_HOLIDAY_MIN 		= "txtAllHolidayMin";
	public static final String PRM_TXT_HALF_HOLIDAY_HOUR 		= "txtHalfHolidayHour";
	public static final String PRM_TXT_HALF_HOLIDAY_MIN 		= "txtHalfHolidayMin";	
	public static final String PRM_TXT_LATE_NIGHT_START_HOUR	= "txtLateNightStartHour";
	public static final String PRM_TXT_LATE_NIGHT_START_MIN 	= "txtLateNightStartMin";
	public static final String PRM_TXT_LATE_NIGHT_TIME_HOUR 	= "txtLateNightTimeHour";
	public static final String PRM_TXT_LATE_NIGHT_TIME_MIN 	= "txtLateNightTimeMin";

	public static final String PRM_TXT_PASSWORD_TERM 			= "txtPasswordTerm";

	// tB[h
	private String	txtStatutoryHours;
	private String	txtStatutoryWeek;
	private String	txtStatutoryMonthHours;
	private String	txtStatutoryMonthDays;
	private String	pltCalcMonth;
	private String	txtCalcDays;
	private String	pltProvidedMonth;
	private String	txtProvidedDays;
	private String	txtInputUnit;
	private String	pltAutoCalc;
	private String	txtAllHolidayHour;
	private String	txtAllHolidayMin;
	private String	txtHalfHolidayHour;
	private String	txtHalfHolidayMin;
	private String	txtLateNightStartHour;
	private String	txtLateNightStartMin;
	private String	txtLateNightTimeHour;
	private String	txtLateNightTimeMin;

	private String	txtPasswordTerm;

	// v_EXg
	public String[][] aryPltAutoCalc;
	public String[][] aryPltCalcMonth;
	public String[][] aryPltProvidedMonth;

	// [h(1FXV)
	private int mode;

	// tB[hyѐ
	public static final String NAM_STATUTORY_HOUR				= CommonConst.NAM_UNIT_DAY + CommonConst.NAM_STATUTORY_HOUR;
	public static final String NAM_STATUTORY_WEEK				= CommonConst.NAM_UNIT_WEEK + CommonConst.NAM_STATUTORY_HOUR;
	public static final String NAM_STATUTORY_MONTH_HOURS		= CommonConst.NAM_UNIT_MONTHRY + CommonConst.NAM_STATUTORY_HOUR;
	public static final String NAM_STATUTORY_MONTH_DAYS		= CommonConst.NAM_UNIT_MONTHRY + CommonConst.NAM_STATUTORY_DAYS;
	public static final String NAM_CALCULATION 				= CommonConst.NAM_CONFIRM_ATTENDANCE + CommonConst.NAM_PERIOD_DATE;
	public static final String NAM_PROVIDED 					= CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_PROVIDED_DATE ;
	public static final String NAM_INPUT_UNIT_TIMES 			= CommonConst.NAM_COMMON_INPUT + CommonConst.NAM_UNIT;
	public static final String NAM_AUTOMATIC_CALCULATION 		= CommonConst.NAM_AUTOMATIC_CALCULATION;
	public static final String NAM_VACATION_LEAVE 			= CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_HOLIDAY_HOURS_ALL			= CommonConst.NAM_VACATION_LEAVE_ALL;
	public static final String NAM_HOLIDAY_HOURS_ALL_HOUR		= CommonConst.NAM_VACATION_LEAVE_ALL + CommonConst.MSG_HOUR;
	public static final String NAM_HOLIDAY_HOURS_ALL_MIN		= CommonConst.NAM_VACATION_LEAVE_ALL + CommonConst.MSG_MINUTES;
	public static final String NAM_HOLIDAY_HOURS_HALF			= CommonConst.NAM_VACATION_LEAVE_HALF;
	public static final String NAM_HOLIDAY_HOURS_HALF_HOUR	= CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.MSG_HOUR;
	public static final String NAM_HOLIDAY_HOURS_HALF_MIN		= CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.MSG_MINUTES;
	public static final String NAM_LATE_NIGHT_START 			= CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_START + CommonConst.NAM_TIME;
	public static final String NAM_LATE_NIGHT_START_HOUR 		= CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_START + CommonConst.NAM_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_LATE_NIGHT_START_MIN 		= CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_START + CommonConst.NAM_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_LATE_NIGHT_HOURS 			= CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LATE_NIGHT_HOURS_HOUR 		= CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_LATE_NIGHT_HOURS_MIN 		= CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;

	public static final String NAM_PASSWORD_TERM 				= CommonConst.NAM_PASSWORD + CommonConst.NAM_PASSWORD_TERM;

	public static final int	LEN_STATUTORY	= 5;
	public static final int	LEN_MONTH		= 1;
	public static final int	LEN_DAYS		= 2;
	public static final int	LEN_TIME		= 2;
	public static final int	LEN_INTEGER2 	= 2;
	public static final int	LEN_INTEGER3 	= 3;
	public static final int	LEN_DECIMAL 	= 1;

	public static final String REG_AUTOMATIC_CALCULATION = CommonConst.REG_DELETE;

	/**
	 * RXgN^
	 */
	public KintaiSystemDefinitionCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setTxtStatutoryHours(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		setTxtStatutoryWeek(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		setTxtStatutoryMonthHours(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		setTxtStatutoryMonthDays(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);
		setPltCalcMonth(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtCalcDays(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setPltProvidedMonth(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtProvidedDays(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtInputUnit(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setPltAutoCalc(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtAllHolidayHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtAllHolidayMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtHalfHolidayHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtHalfHolidayMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtLateNightStartHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtLateNightStartMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtLateNightTimeHour(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		setTxtLateNightTimeMin(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);

		setTxtPasswordTerm(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtStatutoryHours 		= request.getParameter(PRM_TXT_STATUTORY_HOUR);
		txtStatutoryWeek 		= request.getParameter(PRM_TXT_STATUTORY_WEEK);
		txtStatutoryMonthHours 	= request.getParameter(PRM_TXT_STATUTORY_MONTH_HOURS);
		txtStatutoryMonthDays 	= request.getParameter(PRM_TXT_STATUTORY_MONTH_DAYS);
		pltCalcMonth 			= request.getParameter(PRM_PLT_CALCULATION_MONTH);
		txtCalcDays 			= request.getParameter(PRM_TXT_CALCULATION_DAYS);
		pltProvidedMonth 		= request.getParameter(PRM_PLT_PROVIDED_MONTH);
		txtProvidedDays 		= request.getParameter(PRM_TXT_PROVIDED_DAYS);
		txtInputUnit 			= request.getParameter(PRM_TXT_INPUT_UNIT_TIMES);
		pltAutoCalc 			= request.getParameter(PRM_PLT_AUTOMATIC_CALCULATION);
		txtAllHolidayHour 		= request.getParameter(PRM_TXT_ALL_HOLIDAY_HOUR);
		txtAllHolidayMin 		= request.getParameter(PRM_TXT_ALL_HOLIDAY_MIN);
		txtHalfHolidayHour 		= request.getParameter(PRM_TXT_HALF_HOLIDAY_HOUR);
		txtHalfHolidayMin 		= request.getParameter(PRM_TXT_HALF_HOLIDAY_MIN);
		txtLateNightStartHour 	= request.getParameter(PRM_TXT_LATE_NIGHT_START_HOUR);
		txtLateNightStartMin 	= request.getParameter(PRM_TXT_LATE_NIGHT_START_MIN);
		txtLateNightTimeHour 	= request.getParameter(PRM_TXT_LATE_NIGHT_TIME_HOUR);
		txtLateNightTimeMin 	= request.getParameter(PRM_TXT_LATE_NIGHT_TIME_MIN);

		txtPasswordTerm			= request.getParameter(PRM_TXT_PASSWORD_TERM);
	}

	/**
	 * tB[hݒ
	 * @param listStatutory		@JԃXg 
	 */
	public void setFieldStatutoryHours(List listStatutory) {
		// f[^̐ݒ
		Iterator it = listStatutory.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			// @J
			if (dto.getTCode().equals(CommonConst.TCD_STATUTORY_HOUR)) {
				txtStatutoryHours = dto.getTChange();
			}
			// TԖ@J
			if (dto.getTCode().equals(CommonConst.TCD_STATUTORY_DAYS)) {
				txtStatutoryWeek = dto.getTChange();
			}
		}
	}

	/**
	 * tB[hݒ
	 * @param listStatutory		@JԃXg 
	 */
	public void setFieldStatutoryMonth(List listStatutory) {
		// f[^̐ݒ
		Iterator it = listStatutory.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			// Ԗ@J
			if (dto.getTCode().equals(CommonConst.TCD_STATUTORY_HOUR)) {
				txtStatutoryMonthHours = dto.getTChange();
			}
			// Ԗ@J
			if (dto.getTCode().equals(CommonConst.TCD_STATUTORY_DAYS)) {
				txtStatutoryMonthDays = dto.getTChange();
			}
		}
	}

	/**
	 * tB[hݒ
	 * @param listCalc		ߓR[hXg 
	 */
	public void setFieldCalc(List listCalc) {
		// f[^̐ݒ
		Iterator it = listCalc.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			// ΑӒ
			if (dto.getTCode().equals(CommonConst.TCD_MONTH)) {
				pltCalcMonth = dto.getTChange();
			}
			// ΑӒ
			if (dto.getTCode().equals(CommonConst.TCD_DAYS)) {
				txtCalcDays = dto.getTChange();
			}
		}
	}

	/**
	 * tB[hݒ
	 * @param listProvided		xXg 
	 */
	public void setFieldProvided(List listProvided) {
		// f[^̐ݒ
		Iterator it = listProvided.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			// ^x
			if (dto.getTCode().equals(CommonConst.TCD_MONTH)) {
				pltProvidedMonth = dto.getTChange();
			}
			// ^x
			if (dto.getTCode().equals(CommonConst.TCD_DAYS)) {
				txtProvidedDays = dto.getTChange();
			}
		}
	}

	/**
	 * tB[hݒ
	 * @param dto 
	 */
	public void setFieldInputUnit(MCodeDto dto) {
		txtInputUnit = dto.getTChange();
	}

	/**
	 * tB[hݒ
	 * @param listSys		VXeR[hXg 
	 */
	public void setFieldWorkSystem(List listSys) {
		// f[^̐ݒ
		Iterator it = listSys.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			// vZ
			if (dto.getTCode().equals(CommonConst.TCD_AUTOMATIC_CALCULATION)) {
				pltAutoCalc = dto.getTChange();
			}
			// SxAx
			if (dto.getTCode().equals(CommonConst.TCD_HOLIDAY_HOURS)) {
				txtAllHolidayHour = dto.getTChange().substring(0, 2);
				txtAllHolidayMin = dto.getTChange().substring(3, 5);
				txtHalfHolidayHour = dto.getTChange().substring(6, 8);
				txtHalfHolidayMin = dto.getTChange().substring(9, 11);
			}
			if (dto.getTCode().equals(CommonConst.TCD_LATE_NIGHT)) {
				txtLateNightStartHour = dto.getTChange().substring(0, 2);
				txtLateNightStartMin = dto.getTChange().substring(3, 5);
				txtLateNightTimeHour = dto.getTChange().substring(6, 8);
				txtLateNightTimeMin = dto.getTChange().substring(9, 11);
			}
		}
	}

	/**
	 * tB[hݒ
	 * @param days	pX[hL 
	 */
	public void setFieldPasswordTerm(String days) {
		txtPasswordTerm = days;
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldStatutoryHours(MCodeDto dto) {
		dto.setTId(CommonConst.TID_STATUTORY);
		dto.setTCode(CommonConst.TCD_STATUTORY_HOUR);
		dto.setTName("");
		dto.setTChange(txtStatutoryHours);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldStatutoryWeek(MCodeDto dto) {
		dto.setTId(CommonConst.TID_STATUTORY);
		dto.setTCode(CommonConst.TCD_STATUTORY_DAYS);
		dto.setTName("");
		dto.setTChange(txtStatutoryWeek);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldStatutoryMonthHours(MCodeDto dto) {
		dto.setTId(CommonConst.TID_STATUTORY_MONTH);
		dto.setTCode(CommonConst.TCD_STATUTORY_HOUR);
		dto.setTName("");
		dto.setTChange(txtStatutoryMonthHours);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldStatutoryMonthDays(MCodeDto dto) {
		dto.setTId(CommonConst.TID_STATUTORY_MONTH);
		dto.setTCode(CommonConst.TCD_STATUTORY_DAYS);
		dto.setTName("");
		dto.setTChange(txtStatutoryMonthDays);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldCalcMonth(MCodeDto dto) {
		dto.setTId(CommonConst.TID_CALCULATION);
		dto.setTCode(CommonConst.TCD_MONTH);
		dto.setTName(CommonConst.TNM_MONTH_MINUS);
		dto.setTChange(pltCalcMonth);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldCalcDays(MCodeDto dto) {
		dto.setTId(CommonConst.TID_CALCULATION);
		dto.setTCode(CommonConst.TCD_DAYS);
		dto.setTName(CommonConst.TNM_PERIOD_DATE);
		dto.setTChange(txtCalcDays);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldProvidedMonth(MCodeDto dto) {
		dto.setTId(CommonConst.TID_PROVIDED_DATE);
		dto.setTCode(CommonConst.TCD_MONTH);
		dto.setTName(CommonConst.TNM_MONTH_PLUS);
		dto.setTChange(pltProvidedMonth);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldProvidedDays(MCodeDto dto) {
		dto.setTId(CommonConst.TID_PROVIDED_DATE);
		dto.setTCode(CommonConst.TCD_DAYS);
		dto.setTName(CommonConst.TNM_PROVIDED_DATE);
		dto.setTChange(txtProvidedDays);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldInputUnit(MCodeDto dto) {
		dto.setTId(CommonConst.TID_INPUT_UNIT_TIMES);
		dto.setTCode(CommonConst.TCD_MINUTES);
		dto.setTName(CommonConst.TNM_AMOUNT_UNIT);
		dto.setTChange(txtInputUnit);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldAutoCalc(MCodeDto dto) {
		dto.setTId(CommonConst.TID_WORK_SYSTEM);
		dto.setTCode(CommonConst.TCD_AUTOMATIC_CALCULATION);
		dto.setTName(CommonConst.TNM_AMOUNT_UNIT);
		dto.setTChange(pltAutoCalc);
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldHoliday(MCodeDto dto) {
		dto.setTId(CommonConst.TID_WORK_SYSTEM);
		dto.setTCode(CommonConst.TCD_HOLIDAY_HOURS);
		dto.setTName(CommonConst.TNM_AMOUNT_UNIT);
		dto.setTChange(util.convStringToTimeCode(
				txtAllHolidayHour, txtAllHolidayMin,
				txtHalfHolidayHour, txtHalfHolidayMin));
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldLateNight(MCodeDto dto) {
		dto.setTId(CommonConst.TID_WORK_SYSTEM);
		dto.setTCode(CommonConst.TCD_LATE_NIGHT);
		dto.setTName(CommonConst.TNM_AMOUNT_UNIT);
		dto.setTChange(util.convStringToTimeCode(
				txtLateNightStartHour, txtLateNightStartMin,
				txtLateNightTimeHour, txtLateNightTimeMin));
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldPasswordTerm(MCodeDto dto) {
		dto.setTId(CommonConst.TID_PASSWORD_TERM);
		dto.setTCode("");
		dto.setTName("");
		dto.setTChange(txtPasswordTerm);
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtStatutoryHours		, NAM_STATUTORY_HOUR			, PRM_TXT_STATUTORY_HOUR);
		checkRequired(txtStatutoryWeek		, NAM_STATUTORY_WEEK			, PRM_TXT_STATUTORY_WEEK);
		checkRequired(txtStatutoryMonthHours, NAM_STATUTORY_MONTH_HOURS		, PRM_TXT_STATUTORY_MONTH_HOURS);
		checkRequired(txtStatutoryMonthDays	, NAM_STATUTORY_MONTH_DAYS		, PRM_TXT_STATUTORY_MONTH_DAYS);
		checkRequired(txtCalcDays			, NAM_CALCULATION				, PRM_TXT_CALCULATION_DAYS);
		checkRequired(txtProvidedDays		, NAM_PROVIDED					, PRM_TXT_PROVIDED_DAYS);
		checkRequired(txtInputUnit			, NAM_INPUT_UNIT_TIMES			, PRM_TXT_INPUT_UNIT_TIMES);
		checkRequired(txtAllHolidayHour		, NAM_HOLIDAY_HOURS_ALL_HOUR	, PRM_TXT_ALL_HOLIDAY_HOUR);
		checkRequired(txtAllHolidayMin		, NAM_HOLIDAY_HOURS_ALL_MIN		, PRM_TXT_ALL_HOLIDAY_MIN);
		checkRequired(txtHalfHolidayHour	, NAM_HOLIDAY_HOURS_HALF_HOUR	, PRM_TXT_HALF_HOLIDAY_HOUR);
		checkRequired(txtHalfHolidayMin		, NAM_HOLIDAY_HOURS_HALF_MIN	, PRM_TXT_HALF_HOLIDAY_MIN);
		checkRequired(txtLateNightStartHour	, NAM_LATE_NIGHT_START_HOUR		, PRM_TXT_LATE_NIGHT_START_HOUR);
		checkRequired(txtLateNightStartMin	, NAM_LATE_NIGHT_START_MIN		, PRM_TXT_LATE_NIGHT_START_MIN);
		checkRequired(txtLateNightTimeHour	, NAM_LATE_NIGHT_HOURS_HOUR		, PRM_TXT_LATE_NIGHT_TIME_HOUR);
		checkRequired(txtLateNightTimeMin	, NAM_LATE_NIGHT_HOURS_MIN		, PRM_TXT_LATE_NIGHT_TIME_MIN);

		checkRequired(txtPasswordTerm		, NAM_PASSWORD_TERM				, PRM_TXT_PASSWORD_TERM);
		// ^CvmF
		checkNumeric(txtStatutoryHours		, NAM_STATUTORY_HOUR			, PRM_TXT_STATUTORY_HOUR);
		checkNumeric(txtStatutoryWeek		, NAM_STATUTORY_WEEK			, PRM_TXT_STATUTORY_WEEK);
		checkNumeric(txtStatutoryMonthHours	, NAM_STATUTORY_MONTH_HOURS		, PRM_TXT_STATUTORY_MONTH_HOURS);
		checkNumeric(txtStatutoryMonthDays	, NAM_STATUTORY_MONTH_DAYS		, PRM_TXT_STATUTORY_MONTH_DAYS);
		checkNumber(txtCalcDays				, NAM_CALCULATION				, PRM_TXT_CALCULATION_DAYS);
		checkNumber(txtProvidedDays			, NAM_PROVIDED					, PRM_TXT_PROVIDED_DAYS);
		checkNumber(txtInputUnit			, NAM_INPUT_UNIT_TIMES			, PRM_TXT_INPUT_UNIT_TIMES);
		checkNumber(txtAllHolidayHour		, NAM_HOLIDAY_HOURS_ALL_HOUR	, PRM_TXT_ALL_HOLIDAY_HOUR);
		checkNumber(txtAllHolidayMin		, NAM_HOLIDAY_HOURS_ALL_MIN 	, PRM_TXT_ALL_HOLIDAY_MIN);
		checkNumber(txtHalfHolidayHour		, NAM_HOLIDAY_HOURS_HALF_HOUR  	, PRM_TXT_HALF_HOLIDAY_HOUR);
		checkNumber(txtHalfHolidayMin		, NAM_HOLIDAY_HOURS_HALF_MIN  	, PRM_TXT_HALF_HOLIDAY_MIN);
		checkNumber(txtLateNightStartHour	, NAM_LATE_NIGHT_START_HOUR  	, PRM_TXT_LATE_NIGHT_START_HOUR);
		checkNumber(txtLateNightStartMin	, NAM_LATE_NIGHT_START_MIN  	, PRM_TXT_LATE_NIGHT_START_MIN);
		checkNumber(txtLateNightTimeHour	, NAM_LATE_NIGHT_HOURS_HOUR  	, PRM_TXT_LATE_NIGHT_TIME_HOUR);
		checkNumber(txtLateNightTimeMin		, NAM_LATE_NIGHT_HOURS_MIN  	, PRM_TXT_LATE_NIGHT_TIME_MIN);
		checkRegex(pltAutoCalc   			, REG_AUTOMATIC_CALCULATION 	, NAM_AUTOMATIC_CALCULATION, PRM_PLT_AUTOMATIC_CALCULATION);

		checkNumber(txtPasswordTerm			, NAM_PASSWORD_TERM				, PRM_TXT_PASSWORD_TERM);
		// 񒷊mF
		checkLength(txtStatutoryHours		, LEN_STATUTORY	, NAM_STATUTORY_HOUR			, PRM_TXT_STATUTORY_HOUR);
		checkLength(txtStatutoryWeek		, LEN_STATUTORY	, NAM_STATUTORY_WEEK			, PRM_TXT_STATUTORY_WEEK);
		checkLength(txtStatutoryMonthHours	, LEN_STATUTORY	, NAM_STATUTORY_MONTH_HOURS		, PRM_TXT_STATUTORY_MONTH_HOURS);
		checkLength(txtStatutoryMonthDays	, LEN_STATUTORY	, NAM_STATUTORY_MONTH_DAYS		, PRM_TXT_STATUTORY_MONTH_DAYS);
		checkLength(txtCalcDays				, LEN_DAYS		, NAM_CALCULATION				, PRM_TXT_CALCULATION_DAYS);
		checkLength(txtProvidedDays			, LEN_DAYS		, NAM_PROVIDED					, PRM_TXT_PROVIDED_DAYS);
		checkLength(txtInputUnit			, LEN_TIME		, NAM_INPUT_UNIT_TIMES			, PRM_TXT_INPUT_UNIT_TIMES);
		checkLength(txtAllHolidayHour		, LEN_TIME		, NAM_HOLIDAY_HOURS_ALL_HOUR	, PRM_TXT_ALL_HOLIDAY_HOUR);
		checkLength(txtAllHolidayMin		, LEN_TIME		, NAM_HOLIDAY_HOURS_ALL_MIN		, PRM_TXT_ALL_HOLIDAY_MIN);
		checkLength(txtHalfHolidayHour		, LEN_TIME		, NAM_HOLIDAY_HOURS_HALF_HOUR	, PRM_TXT_HALF_HOLIDAY_HOUR);
		checkLength(txtHalfHolidayMin		, LEN_TIME		, NAM_HOLIDAY_HOURS_HALF_MIN	, PRM_TXT_HALF_HOLIDAY_MIN);
		checkLength(txtLateNightStartHour	, LEN_TIME		, NAM_LATE_NIGHT_START_HOUR		, PRM_TXT_LATE_NIGHT_START_HOUR);
		checkLength(txtLateNightStartMin	, LEN_TIME		, NAM_LATE_NIGHT_START_MIN		, PRM_TXT_LATE_NIGHT_START_MIN);
		checkLength(txtLateNightTimeHour	, LEN_TIME		, NAM_LATE_NIGHT_HOURS_HOUR		, PRM_TXT_LATE_NIGHT_TIME_HOUR);
		checkLength(txtLateNightTimeMin		, LEN_TIME		, NAM_LATE_NIGHT_HOURS_MIN		, PRM_TXT_LATE_NIGHT_TIME_MIN);

		checkLength(txtPasswordTerm			, LEN_DAYS		, NAM_PASSWORD_TERM				, PRM_TXT_PASSWORD_TERM);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getTxtStatutoryHours() 		{ return txtStatutoryHours		; }
	public String getTxtStatutoryWeek() 		{ return txtStatutoryWeek		; }
	public String getTxtStatutoryMonthHours() 	{ return txtStatutoryMonthHours	; }
	public String getTxtStatutoryMonthDays() 	{ return txtStatutoryMonthDays	; }
	public String getPltCalcMonth() 			{ return pltCalcMonth			; }
	public String getTxtCalcDays() 				{ return txtCalcDays			; }
	public String getPltProvidedMonth() 		{ return pltProvidedMonth		; }
	public String getTxtProvidedDays() 			{ return txtProvidedDays		; }
	public String getTxtInputUnit()				{ return txtInputUnit			; }
	public String getPltAutoCalc() 				{ return pltAutoCalc			; }
	public String getTxtAllHolidayHour() 		{ return txtAllHolidayHour		; }
	public String getTxtAllHolidayMin() 		{ return txtAllHolidayMin		; }
	public String getTxtHalfHolidayHour() 		{ return txtHalfHolidayHour		; }
	public String getTxtHalfHolidayMin() 		{ return txtHalfHolidayMin		; }
	public String getTxtLateNightStartHour() 	{ return txtLateNightStartHour	; }
	public String getTxtLateNightStartMin() 	{ return txtLateNightStartMin	; }
	public String getTxtLateNightTimeHour() 	{ return txtLateNightTimeHour	; }
	public String getTxtLateNightTimeMin() 		{ return txtLateNightTimeMin	; }

	public String getTxtPasswordTerm() 			{ return txtPasswordTerm		; }

	public String getEscTxtStatutoryHours() 		{ return escapeHTML(txtStatutoryHours)		; }
	public String getEscTxtStatutoryWeek() 			{ return escapeHTML(txtStatutoryWeek)		; }
	public String getEscTxtStatutoryMonthHours()	{ return escapeHTML(txtStatutoryMonthHours)	; }
	public String getEscTxtStatutoryMonthDays()		{ return escapeHTML(txtStatutoryMonthDays)	; }
	public String getEscPltCalcMonth()				{ return escapeHTML(pltCalcMonth)			; }
	public String getEscTxtCalcDays() 				{ return escapeHTML(txtCalcDays)			; }
	public String getEscPltProvidedMonth() 			{ return escapeHTML(pltProvidedMonth)		; }
	public String getEscTxtProvidedDays() 			{ return escapeHTML(txtProvidedDays)		; }
	public String getEscTxtInputUnit() 				{ return escapeHTML(txtInputUnit)			; }
	public String getEscPltAutoCalc() 				{ return escapeHTML(pltAutoCalc)			; }
	public String getEscTxtAllHolidayHour() 		{ return escapeHTML(txtAllHolidayHour)		; }
	public String getEscTxtAllHolidayMin() 			{ return escapeHTML(txtAllHolidayMin)		; }
	public String getEscTxtHalfHolidayHour() 		{ return escapeHTML(txtHalfHolidayHour)		; }
	public String getEscTxtHalfHolidayMin() 		{ return escapeHTML(txtHalfHolidayMin)		; }
	public String getEscTxtLateNightStartHour() 	{ return escapeHTML(txtLateNightStartHour)	; }
	public String getEscTxtLateNightStartMin() 		{ return escapeHTML(txtLateNightStartMin)	; }
	public String getEscTxtLateNightTimeHour() 		{ return escapeHTML(txtLateNightTimeHour)	; }
	public String getEscTxtLateNightTimeMin() 		{ return escapeHTML(txtLateNightTimeMin)	; }

	public String getEscTxtPasswordTerm() 			{ return escapeHTML(txtPasswordTerm)		; }

	public void setTxtStatutoryHours		(String txtStatutoryHours		)	{ this.txtStatutoryHours 		= txtStatutoryHours		; }
	public void setTxtStatutoryWeek		(String txtStatutoryWeek		)	{ this.txtStatutoryWeek 		= txtStatutoryWeek		; }
	public void setTxtStatutoryMonthHours	(String txtStatutoryMonthHours	)	{ this.txtStatutoryMonthHours 	= txtStatutoryMonthHours; }
	public void setTxtStatutoryMonthDays	(String txtStatutoryMonthDays	)	{ this.txtStatutoryMonthDays 	= txtStatutoryMonthDays	; }
	public void setPltCalcMonth			(String pltCalcMonth			)	{ this.pltCalcMonth 			= pltCalcMonth			; }
	public void setTxtCalcDays				(String txtCalcDays				)	{ this.txtCalcDays 				= txtCalcDays			; }
	public void setPltProvidedMonth		(String pltProvidedMonth		) 	{ this.pltProvidedMonth 		= pltProvidedMonth		; }
	public void setTxtProvidedDays			(String txtProvidedDays			) 	{ this.txtProvidedDays 			= txtProvidedDays		; }
	public void setTxtInputUnit			(String txtInputUnit			)	{ this.txtInputUnit 			= txtInputUnit			; }
	public void setPltAutoCalc				(String pltAutoCalc				)	{ this.pltAutoCalc 				= pltAutoCalc			; }
	public void setTxtAllHolidayHour		(String txtAllHolidayHour		)	{ this.txtAllHolidayHour 		= txtAllHolidayHour		; }
	public void setTxtAllHolidayMin		(String txtAllHolidayMin		)	{ this.txtAllHolidayMin 		= txtAllHolidayMin		; }
	public void setTxtHalfHolidayHour		(String txtHalfHolidayHour		)	{ this.txtHalfHolidayHour 		= txtHalfHolidayHour	; }
	public void setTxtHalfHolidayMin		(String txtHalfHolidayMin		)	{ this.txtHalfHolidayMin 		= txtHalfHolidayMin		; }
	public void setTxtLateNightStartHour	(String txtLateNightStartHour	)	{ this.txtLateNightStartHour 	= txtLateNightStartHour	; }
	public void setTxtLateNightStartMin	(String txtLateNightStartMin	)	{ this.txtLateNightStartMin 	= txtLateNightStartMin	; }
	public void setTxtLateNightTimeHour	(String txtLateNightTimeHour	)	{ this.txtLateNightTimeHour 	= txtLateNightTimeHour	; }
	public void setTxtLateNightTimeMin		(String txtLateNightTimeMin		)	{ this.txtLateNightTimeMin 		= txtLateNightTimeMin	; }

	public void setTxtPasswordTerm			(String txtPasswordTerm			) 	{ this.txtPasswordTerm 			= txtPasswordTerm		; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
